import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: blur
    name: "blur"
    effectName: "Blur"
    enabled: sync(blur.name+".ON")

    property real posX: 0.0
    property real posY: 0.0
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }

//    Blit {
//        textureRT: "screenBuffer1"
//        blitRT: 0
//    }

    Blit {
        textureRT: "tBase"
        blitRT: 0
    }

    Texture {
        textureUnit: 1
        textureRT: "tBase"
    }

    Repeater {
        model: sync(blur.name+".blurLoops")
        delegate: Group {
            Blit {
                textureRT: "screenBuffer"
                blitRT: 0
            }
            Blit {
                textureRT: "screenBuffer"+index
                blitRT: 0
            }
            Shader {
                file: "blurWithDepth"
                ShaderParam {
                    paramName: "g_blurStrength"
                    property real strengthAddPerLoop: sync(blur.name+".strength.addPerLoop")
                    paramValue: sync(blur.name+".strength")*(1.0+index*strengthAddPerLoop)
                }
            }
            DrawVB {
                type: "quad"
                depthTest: false
                depthWrite: false
                drawBuffers: 1
            }


        }
    }


//    Blit {
//        textureRT: "colorBuffer"
//    }
//    Texture {
//        textureUnit: 0
//        textureRT: "colorBuffer"
//    }
//    Texture {
//        textureUnit: 1
//        textureRT: "screenBuffer2"
//    }

//    Shader {
//        file: "fx/_SharedQML/overlayAdd"
//    }

//    DrawVB {
//        ShaderParam {
//            paramName: "flip"
//            paramValue: 0.0
//        }
//        ShaderParam {
//            paramName: "overlayAlpha"
//            paramValue: 0.25
//        }
//        ShaderParam {
//            paramName: "g_overlayScale"
//            paramValue: 1.0
//        }
//        ShaderParam {
//            paramName: "g_posX"
//            paramValue: 0.0
//        }
//        ShaderParam {
//            paramName: "g_posY"
//            paramValue: 0.0
//        }

//        type: "quad"
//        depthTest: false
//        depthWrite: false
//    }



}
